use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- Script 65
IF EXISTS (SELECT 1 FROM sysindexes WHERE name = ''IX_ActivityHistorySurveyId'')
BEGIN
    DROP INDEX [IX_ActivityHistorySurveyId]
    ON [dbo].[ActivityHistories];
END
'

declare @PanelClientPayload02 nvarchar(max) = N'
IF NOT EXISTS (SELECT 1 FROM sysindexes WHERE name = ''IX_ActivityHistory_SurveyId_RespondentId'')
BEGIN
    CREATE INDEX [IX_ActivityHistory_SurveyId_RespondentId]
    ON [dbo].[ActivityHistories] ([SurveyId], [RespondentId])
    INCLUDE ([Id], [DateTime], [PanelistId]);
END
'

declare @PanelClientPayload03 nvarchar(max) = N'
IF NOT EXISTS (SELECT 1 FROM sysindexes WHERE name = ''IX_ActivityHistories_SurveyActivityHistory_Index'')
BEGIN
    CREATE INDEX [IX_ActivityHistories_SurveyActivityHistory_Index]
    ON [dbo].[ActivityHistories_SurveyActivityHistory] ([Index]);
END
'

declare @PanelClientPayload04 nvarchar(max) = N'
IF NOT EXISTS (SELECT 1 FROM sysindexes WHERE name = ''IX_PanelistRespondents_SurveyId_RespondentId'')
BEGIN
    CREATE INDEX [IX_PanelistRespondents_SurveyId_RespondentId]
    ON [dbo].[PanelistRespondents] ([SurveyId], [RespondentId]);
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL
		
		select @SQL = replace(replace(@PanelClientPayload03, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@PanelClientPayload04, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
